﻿//////////////////////////////////////////////
// MathConstants.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Class ------------------------------------

namespace nkMaths
{
	class MathConstants
	{
		public :

			static constexpr float PI = 3.1415926535897932384626433832795f ;

			static constexpr float PI_SQRT = 1.7724538509055160272981674833411f ;

			static constexpr float PI_2 = 2.f * PI ;
			static constexpr float PI_4 = 4.f * PI ;

			static constexpr float PI_OVER_2 = 0.5f * PI ;
			static constexpr float PI_OVER_3 = (1.f / 3.f) * PI ;
			static constexpr float PI_OVER_4 = 0.25f * PI ;
			static constexpr float PI_OVER_6 = (1.f / 6.f) * PI ;
			static constexpr float PI_OVER_8 = (1.f / 8.f) * PI ;
	} ;
}